/////////////////////////////////////////////////////////////////////////
// Eaten // Dodge stuff and try to survive //////////////////////////////
/////////////////////////////////////////////////////////////////////////
/*
Core Coder: PSPOwnage
Special Thanks: Slasher & Team Duck
*/

// INCLUDES
#include <pspdebug.h>
#include <pspkernel.h>
#include <pspdisplay.h>
#include <pspctrl.h>
#include <pspsdk.h>
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <string.h>

#include "graphics.h"		// Graphics
#include "framebuffer.h"	// Graphics


// DEFINES
#define printf			pspDebugScreenPrintf 
#define	MAX(X, Y)		((X) > (Y) ? (X) : (Y))
#define RGB(r, g, b)	(0xFF000000 | ((b)<<16) | ((g)<<8) | (r))
#define CPUSPEED		333

#define MAX_ENEMIES		500
#define MAX_BULLETS		500
#define MAX_HEALTH		100
#define MAX_POWERUPS	50

#define BULLET_PAUSE	25
#define BULLET_UP		1
#define BULLET_RIGHT	2
#define BULLET_DOWN		3
#define	BULLET_LEFT		4
#define BULLET_SPEED	4

#define POWERUP_TIMER	2000

#define STORY_MODE		1
#define DODGE_MODE		2

//#define __DEBUG_			// Debug


// MODULE INFO
PSP_MODULE_INFO("EatenV2", 0x1000, 1, 1);	// Kernel, since everyone has 1.5 now :X
PSP_MAIN_THREAD_ATTR(0);


// GLOBALS //

typedef struct enemyInfo {

	int active;		// active or not
	int x;			// Floating X value
	int	y;			// Floating Y value
	int speed;		// Speed at which it moves

} enemyInfo;

enemyInfo enemy[MAX_ENEMIES+5];	// excess just incase


typedef struct stillInfo {

	int active;		// active or not
	int x;			// Floating X value
	int	y;			// Floating Y value

} stillInfo;

stillInfo stillEnemy[MAX_ENEMIES+5];	// excess just incase


typedef struct bulletInfo {

	int active;		// active or not
	int x;			// Floating X value
	int y;			// Floating Y value
	int dir;		// Direction. 1UP/2RIGHT/3DOWN/4LEFT
	
} bulletInfo;

bulletInfo bullet[MAX_BULLETS+5];	// excess just incase


typedef struct powerInfo {

	int active;		// active or not
	int x;			// Floating X value
	int y;			// Floating Y value
	int type;		// Type. 1SPEED/2BULLETSPEED/3SHRINK/4INVINCIBILITY
	
} powerInfo;

powerInfo power[MAX_POWERUPS+5];	// excess just incase


Image* imgBackground;
Image* imgBullet;

int playerX;
int playerY;
int playerMoveX;
int playerMoveY;

int level;
int pick;
int activater;
int confirm;
int activaterRan;
int activaterRan2;
int activaterRan3;

int powerSpeed;
int powerSpeedTime;
int powerBullet;
int powerBulletTime;
int powerShrink;
int powerShrinkTime;
int powerInvince;
int powerInvinceTime;

char cont[255];

int numOfEnemies;
int health;
int dead;

int menuOption;
int storyHighScore;
int storyScore;
int dodgeHighScore;

int timer;
int powerUpTimer;

int curPowerUp;
int curBullet;


// FUNCTIONS //

void debug(char *text, int micro) {
	printf(text);
	sceKernelDelayThread(micro);
}

int randomNum(int min, int max) {
	int diff = max - min;
	return (rand() % diff)+min;
}

void initVars(void) {
	srand(sceKernelLibcTime(NULL));	// seed
	playerX = 480/2;
	playerY = 272/2;
	pick = 1;
	activater = 0;
	activaterRan = randomNum(100, 200);
	activaterRan2 = 0;
	activaterRan3 = 0;
	numOfEnemies = 0;
	health = MAX_HEALTH;
	confirm = 0;
	dead = 0;
	menuOption = 1;
	timer = 0;
	curBullet = 1;
	curPowerUp = 1;
	storyScore = 0;
	powerUpTimer = POWERUP_TIMER;
	powerSpeed = 0;
	powerSpeedTime = 0;
	powerBullet = 0;
	powerBulletTime = 0;
	powerShrink = 0;
	powerShrinkTime = 0;
	powerInvince = 0;
	powerInvinceTime = 0;
	int i;
	for (i=1; i<=MAX_ENEMIES; i++) { // Set to default
		enemy[i].active = 0;
		enemy[i].speed = 1;
		enemy[i].x = -20;
		enemy[i].y = 10;
	}
	for (i=1; i<=MAX_BULLETS; i++) {
		bullet[i].active = 0;
		bullet[i].x = 0;
		bullet[i].y = 0;
		bullet[i].dir = 0;
	}
	for (i=1; i<=MAX_ENEMIES; i++) {
		stillEnemy[i].active = 0;
		stillEnemy[i].x = 0;
		stillEnemy[i].y = 0;
	}
	for (i=1; i<=MAX_POWERUPS; i++) {
		power[i].active = 0;
		power[i].x = 0;
		power[i].y = 0;
		power[i].type = 0;
	}
}

void centerText(int centerX, int centerY, char * centerText, int centerLength, u32 color) {
	if (strlen(centerText) <= centerLength) {
		int center = ((centerX)-((strlen(centerText)/2)*8));
		printTextScreen(center, centerY, centerText, color);
	}
	else {
		int center = ((centerX)-(centerLength/2)*8);
		char str[255];
		strncpy(str, centerText, centerLength);
		str[centerLength-3] = '.';
		str[centerLength-2] = '.';
		str[centerLength-1] = '.';
		str[centerLength] = '\0';
		printTextScreen(center, centerY, str, color);
	}
}

int initLevel(int theLevel, int theAmount) {
	int i;
	for (i=1; i<=MAX_ENEMIES; i++) { // Set to default
		enemy[i].active = 0;
		enemy[i].speed = 1;
		enemy[i].x = -20;
		enemy[i].y = 10;
	}
	for (i=1; i<=MAX_ENEMIES; i++) {
		stillEnemy[i].active = 0;
		stillEnemy[i].x = 0;
		stillEnemy[i].y = 0;
	}
	for (i=1; i<=MAX_POWERUPS; i++) {
		power[i].active = 0;
		power[i].x = 0;
		power[i].y = 0;
		power[i].type = 0;
	}

	if (theLevel == STORY_MODE) {
		for (i=1; i<=MAX_ENEMIES; i++) {
			// Set active to 0
			enemy[i].active = 0;

			// Speed
			enemy[i].speed = randomNum(1, 10);		// Random num between 1 and 10
			if (enemy[i].speed < 1) enemy[i].speed = 1;
			if ((enemy[i].speed >= 1) && (enemy[i].speed < 2)) enemy[i].speed = 1;
			if ((enemy[i].speed >= 2) && (enemy[i].speed < 3)) enemy[i].speed = 1;
			if ((enemy[i].speed >= 3) && (enemy[i].speed < 4)) enemy[i].speed = 2;
			if ((enemy[i].speed >= 4) && (enemy[i].speed < 5)) enemy[i].speed = 3;
			if ((enemy[i].speed >= 5) && (enemy[i].speed < 6)) enemy[i].speed = 3;
			if ((enemy[i].speed >= 6) && (enemy[i].speed < 7)) enemy[i].speed = 2;
			if ((enemy[i].speed >= 7) && (enemy[i].speed < 8)) enemy[i].speed = 3;
			if ((enemy[i].speed >= 8) && (enemy[i].speed < 9)) enemy[i].speed = 4;
			if ((enemy[i].speed >= 9) && (enemy[i].speed < 10)) enemy[i].speed = 4;
			if ((enemy[i].speed >= 10) && (enemy[i].speed < 11)) enemy[i].speed = 2;
			
			// X & Y
			enemy[i].x = -20;
			enemy[i].y = randomNum(1, 252);
		}

		for (i=1; i<=MAX_ENEMIES; i++) {
			stillEnemy[i].active = 0;
			stillEnemy[i].x = randomNum(1, 460);
			stillEnemy[i].y = randomNum(1, 252);
		}

		for (i=1; i<=MAX_POWERUPS; i++) {
			power[i].active = 0;
			power[i].x = randomNum(1, 460);
			power[i].y = randomNum(1, 252);
			power[i].type = randomNum(0, 5);
			if (power[i].type <= 1) power[i].type = 1;
			if ((power[i].type > 1) && (power[i].type <= 2)) power[i].type = 2;
			if ((power[i].type > 2) && (power[i].type <= 3)) power[i].type = 3;
			if (power[i].type > 3) power[i].type = 4;
		}
	}
	else if (theLevel == DODGE_MODE) {
		for (i=1; i<=MAX_ENEMIES; i++) {
			// Set active to 0
			enemy[i].active = 0;

			// Speed
			enemy[i].speed = randomNum(1, 10);		// Random num between 0 and 11
			if (enemy[i].speed < 1) enemy[i].speed = 1;
			if ((enemy[i].speed >= 1) && (enemy[i].speed < 2)) enemy[i].speed = 1;
			if ((enemy[i].speed >= 2) && (enemy[i].speed < 3)) enemy[i].speed = 1;
			if ((enemy[i].speed >= 3) && (enemy[i].speed < 4)) enemy[i].speed = 2;
			if ((enemy[i].speed >= 4) && (enemy[i].speed < 5)) enemy[i].speed = 3;
			if ((enemy[i].speed >= 5) && (enemy[i].speed < 6)) enemy[i].speed = 3;
			if ((enemy[i].speed >= 6) && (enemy[i].speed < 7)) enemy[i].speed = 2;
			if ((enemy[i].speed >= 7) && (enemy[i].speed < 8)) enemy[i].speed = 3;
			if ((enemy[i].speed >= 8) && (enemy[i].speed < 9)) enemy[i].speed = 4;
			if ((enemy[i].speed >= 9) && (enemy[i].speed < 10)) enemy[i].speed = 4;
			if ((enemy[i].speed >= 10) && (enemy[i].speed < 11)) enemy[i].speed = 2;
			
			// X & Y
			enemy[i].x = -20;
			enemy[i].y = randomNum(1, 252);
		}
	}

	return 1;
}

void draw(int mode) {
	int i;

	// Display
	blitAlphaImageToScreen(0, 0, 480, 272, imgBackground, 0, 0);	// Background
	if (!(powerShrink)) {
		fillScreenRect(RGB(255, 0, 0), playerX, playerY, 20, 20);		// The Player
		fillScreenRect(RGB(200, 0, 0), playerX+1, playerY+1, 18, 18);	//
		fillScreenRect(RGB(255, 0, 0), playerX+2, playerY+2, 16, 16);	//
		fillScreenRect(RGB(200, 0, 0), playerX+3, playerY+3, 14, 14);	//
		fillScreenRect(RGB(255, 0, 0), playerX+4, playerY+4, 12, 12);	//
		fillScreenRect(RGB(200, 0, 0), playerX+5, playerY+5, 10, 10);	//
		fillScreenRect(RGB(255, 0, 0), playerX+6, playerY+6, 8, 8);		//
		fillScreenRect(RGB(200, 0, 0), playerX+7, playerY+7, 6, 6);		//
		fillScreenRect(RGB(255, 0, 0), playerX+8, playerY+8, 4, 4);		//
		fillScreenRect(RGB(200, 0, 0), playerX+9, playerY+9, 2, 2);		//
		fillScreenRect(RGB(200, 0, 0), playerX+10, playerY+10, 0, 0);	// The Player
	}
	else {
		fillScreenRect(RGB(255, 0, 0), playerX, playerY, 10, 10);		// The Player (shrinked)
		fillScreenRect(RGB(200, 0, 0), playerX+1, playerY+1, 8, 8);		//
		fillScreenRect(RGB(255, 0, 0), playerX+2, playerY+2, 6, 6);		//
		fillScreenRect(RGB(200, 0, 0), playerX+3, playerY+3, 4, 4);		//
		fillScreenRect(RGB(255, 0, 0), playerX+4, playerY+4, 2, 2);		//
		fillScreenRect(RGB(200, 0, 0), playerX+5, playerY+5, 0, 0);		// The Player
	}
	
	// Enemies
	for (i=1; i<=MAX_ENEMIES; i++) {
		if (enemy[i].active) {
			// Display
			fillScreenRect(RGB(0, 0, 255), enemy[i].x, enemy[i].y, 20, 20);		// The enemy (Outside)
			fillScreenRect(RGB(0, 0, 200), enemy[i].x+2, enemy[i].y+2, 16, 16);		// The enemy (Inside)
		}
		if (stillEnemy[i].active) {
			// Display
			fillScreenRect(RGB(0, 255, 0), stillEnemy[i].x, stillEnemy[i].y, 20, 20);		// The enemy (Outside)
			fillScreenRect(RGB(0, 200, 50), stillEnemy[i].x+1, stillEnemy[i].y+1, 18, 18);		// The enemy (Inside)
			drawLineScreen(stillEnemy[i].x+1, stillEnemy[i].y+1, stillEnemy[i].x+19, stillEnemy[i].y+19, RGB(255, 0, 0));	// The red X
			drawLineScreen(stillEnemy[i].x+1, stillEnemy[i].y+19, stillEnemy[i].x+19, stillEnemy[i].y+1, RGB(255, 0, 0));	// The red X
		}
	}

	// Powerups
	for (i=1; i<=MAX_POWERUPS; i++) {
		if (power[i].active) {
			// Display
			fillScreenRect(RGB(255, 215, 0), power[i].x, power[i].y, 20, 20);
			fillScreenRect(RGB(255, 255, 0), power[i].x+2, power[i].y+2, 16, 16);
		}
	}

	// Bullets
	for (i=1; i<=MAX_BULLETS; i++) {
		if (bullet[i].active) {
			// Display
			blitAlphaImageToScreen(0, 0, 11, 11, imgBullet, bullet[i].x, bullet[i].y); // The bullet
		}
	}

	// HUD
	if (mode == STORY_MODE) {
		char stat[100];
		sprintf(stat, "Health: %02d", health);
		printTextScreen(1, 1, stat, RGB(255, 255, 255));
		char stat4[100];
		sprintf(stat4, "Score: %02d", storyScore);
		printTextScreen(1, 11, stat4, RGB(255, 255, 255));
		char stat6[100];
		sprintf(stat6, "Speed: %02d, Bullet: %02d, Shrink: %02d, Invincibility: %02d", powerSpeedTime, powerBulletTime, powerShrinkTime, powerInvinceTime);
		centerText(480/2, 261, stat6, strlen(stat6), RGB(255, 255, 255));
	}
	else if (mode == DODGE_MODE) {
		char stat1[100];
		sprintf(stat1, "Dodged: %02d", numOfEnemies);
		char stat2[100];
		sprintf(stat2, "Health: %02d", health);
		char stat3[100];
		sprintf(stat3, "Level: %02d", level);
		printTextScreen(1, 1, stat2, RGB(255, 255, 255));
		printTextScreen(1, 11, stat1, RGB(255, 255, 255));
		centerText(480/2, 0, stat3, strlen(stat3), RGB(255, 255, 255));
	}
}

void controlBullets() {
	int i;
	if (curBullet >= MAX_BULLETS) {
		for (i=1; i<=MAX_BULLETS; i++) {
			if (!(bullet[i].active)) {
				bullet[i].active = 0;
				bullet[i].x = 0;
				bullet[i].y = 0;
				bullet[i].dir = 0;
			}
			else if (bullet[i].active) break;

			if (i==MAX_BULLETS) curBullet = 1;
		}
	}

	for (i=1; i<=MAX_BULLETS; i++) {
		if ((bullet[i].x >= 480) || (bullet[i].x <= -11) || (bullet[i].y >= 272) || (bullet[i].y <= -11)) {
			bullet[i].x = 400;
			bullet[i].y = 400;
			bullet[i].dir = 0;
			bullet[i].active = 0; // Deactivate if out of screen
		}

		if (bullet[i].active) {
			if (!(powerSpeed)) {
				if (bullet[i].dir == 1) {
					bullet[i].y = bullet[i].y - BULLET_SPEED;
				}
				else if (bullet[i].dir == 2) {
					bullet[i].x = bullet[i].x + BULLET_SPEED;
				}
				else if (bullet[i].dir == 3) {
					bullet[i].y = bullet[i].y + BULLET_SPEED;
				}
				else if (bullet[i].dir == 4) {
					bullet[i].x = bullet[i].x - BULLET_SPEED;
				}
			}
			else {
				if (bullet[i].dir == 1) {
					bullet[i].y = bullet[i].y - BULLET_SPEED*2;
				}
				else if (bullet[i].dir == 2) {
					bullet[i].x = bullet[i].x + BULLET_SPEED*2;
				}
				else if (bullet[i].dir == 3) {
					bullet[i].y = bullet[i].y + BULLET_SPEED*2;
				}
				else if (bullet[i].dir == 4) {
					bullet[i].x = bullet[i].x - BULLET_SPEED*2;
				}
			}
		}
	}

	// If bullet hits enemy/if hits green enemy
	int x;
	for (i=1; i<=MAX_BULLETS; i++) {
		if (bullet[i].active) {
			for (x=1; x<=MAX_ENEMIES; x++) {
				// Regular enemy
				if (enemy[x].active) {
					if (((bullet[i].x >= enemy[x].x) && (bullet[i].x <= enemy[x].x+20) && (bullet[i].y >= enemy[x].y) && (bullet[i].y <= enemy[x].y+20))
						|| ((bullet[i].x+10 >= enemy[x].x) && (bullet[i].x+10 <= enemy[x].x+20) && (bullet[i].y >= enemy[x].y) && (bullet[i].y <= enemy[x].y+20))
						|| ((bullet[i].x >= enemy[x].x) && (bullet[i].x <= enemy[x].x+20) && (bullet[i].y+10 >= enemy[x].y) && (bullet[i].y+10 <= enemy[x].y+20))
						|| ((bullet[i].x+10 >= enemy[x].x) && (bullet[i].x+10 <= enemy[x].x+20) && (bullet[i].y+10 >= enemy[x].y) && (bullet[i].y+10 <= enemy[x].y+20))) {
							if (!(powerBullet)) {
								storyScore += 5;
								bullet[i].active = 0;
								enemy[x].active = 0;
							}
							else {
								storyScore += 5;
								enemy[x].active = 0;
							}
					}
				}
				// Green block
				if (stillEnemy[x].active) {
					if (((bullet[i].x >= stillEnemy[x].x) && (bullet[i].x <= stillEnemy[x].x+20) && (bullet[i].y >= stillEnemy[x].y) && (bullet[i].y <= stillEnemy[x].y+20))
						|| ((bullet[i].x+10 >= stillEnemy[x].x) && (bullet[i].x+10 <= stillEnemy[x].x+20) && (bullet[i].y >= stillEnemy[x].y) && (bullet[i].y <= stillEnemy[x].y+20))
						|| ((bullet[i].x >= stillEnemy[x].x) && (bullet[i].x <= stillEnemy[x].x+20) && (bullet[i].y+10 >= stillEnemy[x].y) && (bullet[i].y+10 <= stillEnemy[x].y+20))
						|| ((bullet[i].x+10 >= stillEnemy[x].x) && (bullet[i].x+10 <= stillEnemy[x].x+20) && (bullet[i].y+10 >= stillEnemy[x].y) && (bullet[i].y+10 <= stillEnemy[x].y+20))) {
							if (!(powerBullet)) {
								bullet[i].active = 0;
							}
					}
				}
			}
		}
	}
}

void levelControl(int mode) {
	int i;
	if (mode==STORY_MODE) {
		// Control the level
		if (level == 1) {
			activater++;
			if (activater > activaterRan) {
				enemy[pick].active = 1;
				pick++;
				numOfEnemies++;
				storyScore++;
				if (pick > 25) {
					stillEnemy[pick].active = 1;
					level++;
				}
				for (;;) {
					activater = 0;
					activaterRan = randomNum(100, 150);
					activaterRan2 = randomNum(0, 101);
					activaterRan3 = randomNum(0, 101);
					break;
				}
			}
			else if (activaterRan2 > 80) {	// 20% chance it will activate 2 instead of just 1
				activater = activaterRan;
				activaterRan2 = 0;
				activaterRan3 = 0;
			}
			else if (activaterRan3 > 80) {	// 20% chance it will increase the time for the next enemy to be activated
				activater = activaterRan - 30;
				activaterRan2 = 0;
				activaterRan3 = 0;
			}
		}
		else if (level == 2) {
			activater++;
			if (activater > activaterRan) {
				enemy[pick].active = 1;
				pick++;
				numOfEnemies++;
				storyScore++;
				if (pick > 50) {
					stillEnemy[pick].active = 1;
					level++;
				}
				for (;;) {
					activater = 0;
					activaterRan = randomNum(80, 140);
					activaterRan2 = randomNum(0, 101);
					activaterRan3 = randomNum(0, 101);
					break;
				}
			}
			else if (activaterRan2 > 70) {	// 30% chance it will activate 2 instead of just 1
				activater = activaterRan;
				activaterRan2 = 0;
				activaterRan3 = 0;
			}
			else if (activaterRan3 > 70) {	// 30% chance it will increase the time for the next enemy to be activated
				activater = activaterRan - 40;
				activaterRan2 = 0;
				activaterRan3 = 0;
			}
		}
		else if (level == 3) {
			activater++;
			if (activater > activaterRan) {
				enemy[pick].active = 1;
				pick++;
				numOfEnemies++;
				storyScore++;
				if (pick > 75) {
					stillEnemy[pick].active = 1;
					level++;
				}
				for (;;) {
					activater = 0;
					activaterRan = randomNum(70, 130);
					activaterRan2 = randomNum(0, 101);
					activaterRan3 = randomNum(0, 101);
					break;
				}
			}
			else if (activaterRan2 > 65) {
				activater = activaterRan;
				activaterRan2 = 0;
				activaterRan3 = 0;
			}
			else if (activaterRan3 > 65) {
				activater = activaterRan - 30;
				activaterRan2 = 0;
				activaterRan3 = 0;
			}
		}
		else if (level == 4) {
			activater++;
			if (activater > activaterRan) {
				enemy[pick].active = 1;
				pick++;
				numOfEnemies++;
				storyScore++;
				if (pick > 100) {
					stillEnemy[pick].active = 1;
					level++;
				}
				for (;;) {
					activater = 0;
					activaterRan = randomNum(60, 120);
					activaterRan2 = randomNum(0, 101);
					activaterRan3 = randomNum(0, 101);
					break;
				}
			}
			else if (activaterRan2 > 65) {
				activater = activaterRan;
				activaterRan2 = 0;
				activaterRan3 = 0;
			}
			else if (activaterRan3 > 65) {
				activater = activaterRan - 30;
				activaterRan2 = 0;
				activaterRan3 = 0;
			}
		}
		else if (level == 5) {
			activater++;
			if (activater > activaterRan) {
				enemy[pick].active = 1;
				pick++;
				numOfEnemies++;
				storyScore++;
				if (pick > 125) {
					stillEnemy[pick].active = 1;
					level++;
				}
				for (;;) {
					activater = 0;
					activaterRan = randomNum(50, 100);
					activaterRan2 = randomNum(0, 101);
					activaterRan3 = randomNum(0, 101);
					break;
				}
			}
			else if (activaterRan2 > 60) {
				activater = activaterRan;
				activaterRan2 = 0;
				activaterRan3 = 0;
			}
			else if (activaterRan3 > 55) {
				activater = activaterRan - 30;
				activaterRan2 = 0;
				activaterRan3 = 0;
			}
		}
		else if (level == 6) {
			activater++;
			if (activater > activaterRan) {
				enemy[pick].active = 1;
				pick++;
				numOfEnemies++;
				storyScore++;
				if (pick > 150) {
					stillEnemy[pick].active = 1;
					level++;
				}
				for (;;) {
					activater = 0;
					activaterRan = randomNum(50, 100);
					activaterRan2 = randomNum(0, 101);
					activaterRan3 = randomNum(0, 101);
					break;
				}
			}
			else if (activaterRan2 > 65) {
				activater = activaterRan;
				activaterRan2 = 0;
				activaterRan3 = 0;
			}
			else if (activaterRan3 > 50) {
				activater = activaterRan - 20;
				activaterRan2 = 0;
				activaterRan3 = 0;
			}
		}
		else if (level == 7) {
			activater++;
			if (activater > activaterRan) {
				enemy[pick].active = 1;
				pick++;
				numOfEnemies++;
				storyScore++;
				if (pick > 175) {
					stillEnemy[pick].active = 1;
					level++;
				}
				for (;;) {
					activater = 0;
					activaterRan = randomNum(40, 100);
					activaterRan2 = randomNum(0, 101);
					activaterRan3 = randomNum(0, 101);
					break;
				}
			}
			else if (activaterRan2 > 65) {
				activater = activaterRan;
				activaterRan2 = 0;
				activaterRan3 = 0;
			}
			else if (activaterRan3 > 50) {
				activater = activaterRan - 20;
				activaterRan2 = 0;
				activaterRan3 = 0;
			}
		}
		else if (level == 8) {
			activater++;
			if (activater > activaterRan) {
				enemy[pick].active = 1;
				pick++;
				numOfEnemies++;
				storyScore++;
				if (pick > 200) {
					stillEnemy[pick].active = 1;
					level++;
				}
				for (;;) {
					activater = 0;
					activaterRan = randomNum(20, 80);
					activaterRan2 = randomNum(0, 101);
					activaterRan3 = randomNum(0, 101);
					break;
				}
			}
			else if (activaterRan2 > 60) {
				activater = activaterRan;
				activaterRan2 = 0;
				activaterRan3 = 0;
			}
			else if (activaterRan3 > 30) {
				activater = activaterRan - 20;
				activaterRan2 = 0;
				activaterRan3 = 0;
			}
		}
		else if (level == 9) {
			activater++;
			if (activater > activaterRan) {
				enemy[pick].active = 1;
				pick++;
				numOfEnemies++;
				storyScore++;
				if (pick > 225) {
					stillEnemy[pick].active = 1;
					level++;
				}
				for (;;) {
					activater = 0;
					activaterRan = randomNum(20, 60);
					activaterRan2 = randomNum(0, 101);
					activaterRan3 = randomNum(0, 101);
					break;
				}
			}
			else if (activaterRan2 > 40) {
				activater = activaterRan;
				activaterRan2 = 0;
				activaterRan3 = 0;
			}
			else if (activaterRan3 > 50) {
				activater = activaterRan - 20;
				activaterRan2 = 0;
				activaterRan3 = 0;
			}
		}
		else if (level == 10) {
			activater++;
			if (activater > activaterRan) {
				enemy[pick].active = 1;
				pick++;
				numOfEnemies++;
				storyScore++;
				if (pick > 250) {
					stillEnemy[pick].active = 1;
					level++;
				}
				for (;;) {
					activater = 0;
					activaterRan = randomNum(20, 60);
					activaterRan2 = randomNum(0, 101);
					activaterRan3 = randomNum(0, 101);
					break;
				}
			}
			else if (activaterRan2 > 40) {
				activater = activaterRan;
				activaterRan2 = 0;
				activaterRan3 = 0;
			}
			else if (activaterRan3 > 50) {
				activater = activaterRan - 15;
				activaterRan2 = 0;
				activaterRan3 = 0;
			}
		}
		else if (level == 11) {
			activater++;
			if (activater > activaterRan) {
				enemy[pick].active = 1;
				pick++;
				numOfEnemies++;
				storyScore++;
				if (pick > 275) {
					stillEnemy[pick].active = 1;
					level++;
				}
				for (;;) {
					activater = 0;
					activaterRan = randomNum(20, 60);
					activaterRan2 = randomNum(0, 101);
					activaterRan3 = randomNum(0, 101);
					break;
				}
			}
			else if (activaterRan2 > 40) {
				activater = activaterRan;
				activaterRan2 = 0;
				activaterRan3 = 0;
			}
			else if (activaterRan3 > 50) {
				activater = activaterRan - 15;
				activaterRan2 = 0;
				activaterRan3 = 0;
			}
		}
		else if (level == 12) {
			activater++;
			if (activater > activaterRan) {
				enemy[pick].active = 1;
				pick++;
				numOfEnemies++;
				storyScore++;
				if (pick > 300) {
					stillEnemy[pick].active = 1;
					level++;
				}
				for (;;) {
					activater = 0;
					activaterRan = randomNum(20, 60);
					activaterRan2 = randomNum(0, 101);
					activaterRan3 = randomNum(0, 101);
					break;
				}
			}
			else if (activaterRan2 > 40) {
				activater = activaterRan;
				activaterRan2 = 0;
				activaterRan3 = 0;
			}
			else if (activaterRan3 > 50) {
				activater = activaterRan - 15;
				activaterRan2 = 0;
				activaterRan3 = 0;
			}
		}
		else if (level == 13) {
			activater++;
			if (activater > activaterRan) {
				enemy[pick].active = 1;
				pick++;
				numOfEnemies++;
				storyScore++;
				if (pick > 325) {
					stillEnemy[pick].active = 1;
					level++;
				}
				for (;;) {
					activater = 0;
					activaterRan = randomNum(20, 60);
					activaterRan2 = randomNum(0, 101);
					activaterRan3 = randomNum(0, 101);
					break;
				}
			}
			else if (activaterRan2 > 40) {
				activater = activaterRan;
				activaterRan2 = 0;
				activaterRan3 = 0;
			}
			else if (activaterRan3 > 50) {
				activater = activaterRan - 15;
				activaterRan2 = 0;
				activaterRan3 = 0;
			}
		}
		else if (level == 14) {
			activater++;
			if (activater > activaterRan) {
				enemy[pick].active = 1;
				pick++;
				numOfEnemies++;
				storyScore++;
				if (pick > 350) {
					stillEnemy[pick].active = 1;
					level++;
				}
				for (;;) {
					activater = 0;
					activaterRan = randomNum(10, 60);
					activaterRan2 = randomNum(0, 101);
					activaterRan3 = randomNum(0, 101);
					break;
				}
			}
			else if (activaterRan2 > 40) {
				activater = activaterRan;
				activaterRan2 = 0;
				activaterRan3 = 0;
			}
			else if (activaterRan3 > 30) {
				activater = activaterRan - 15;
				activaterRan2 = 0;
				activaterRan3 = 0;
			}
		}
		else if (level == 15) {
			activater++;
			if (activater > activaterRan) {
				enemy[pick].active = 1;
				pick++;
				numOfEnemies++;
				storyScore++;
				if (pick > 375) {
					stillEnemy[pick].active = 1;
					level++;
				}
				for (;;) {
					activater = 0;
					activaterRan = randomNum(10, 60);
					activaterRan2 = randomNum(0, 101);
					activaterRan3 = randomNum(0, 101);
					break;
				}
			}
			else if (activaterRan2 > 40) {
				activater = activaterRan;
				activaterRan2 = 0;
				activaterRan3 = 0;
			}
			else if (activaterRan3 > 30) {
				activater = activaterRan - 15;
				activaterRan2 = 0;
				activaterRan3 = 0;
			}
		}
		else if (level == 16) {
			activater++;
			if (activater > activaterRan) {
				enemy[pick].active = 1;
				pick++;
				numOfEnemies++;
				storyScore++;
				if (pick > 400) {
					stillEnemy[pick].active = 1;
					level++;
				}
				for (;;) {
					activater = 0;
					activaterRan = randomNum(10, 50);
					activaterRan2 = randomNum(0, 101);
					activaterRan3 = randomNum(0, 101);
					break;
				}
			}
			else if (activaterRan2 > 40) {
				activater = activaterRan;
				activaterRan2 = 0;
				activaterRan3 = 0;
			}
			else if (activaterRan3 > 30) {
				activater = activaterRan - 10;
				activaterRan2 = 0;
				activaterRan3 = 0;
			}
		}
		else if (level == 17) {
			activater++;
			if (activater > activaterRan) {
				enemy[pick].active = 1;
				pick++;
				numOfEnemies++;
				storyScore++;
				if (pick > 425) {
					stillEnemy[pick].active = 1;
					level++;
				}
				for (;;) {
					activater = 0;
					activaterRan = randomNum(10, 50);
					activaterRan2 = randomNum(0, 101);
					activaterRan3 = randomNum(0, 101);
					break;
				}
			}
			else if (activaterRan2 > 40) {
				activater = activaterRan;
				activaterRan2 = 0;
				activaterRan3 = 0;
			}
			else if (activaterRan3 > 30) {
				activater = activaterRan - 10;
				activaterRan2 = 0;
				activaterRan3 = 0;
			}
		}
		else if (level == 18) {
			activater++;
			if (activater > activaterRan) {
				enemy[pick].active = 1;
				pick++;
				numOfEnemies++;
				storyScore++;
				if (pick > 450) {
					stillEnemy[pick].active = 1;
					level++;
				}
				for (;;) {
					activater = 0;
					activaterRan = randomNum(10, 30);
					activaterRan2 = randomNum(0, 101);
					activaterRan3 = randomNum(0, 101);
					break;
				}
			}
			else if (activaterRan2 > 40) {
				activater = activaterRan;
				activaterRan2 = 0;
				activaterRan3 = 0;
			}
			else if (activaterRan3 > 30) {
				activater = activaterRan - 20;
				activaterRan2 = 0;
				activaterRan3 = 0;
			}
		}
		else if (level == 19) {
			activater++;
			if (activater > activaterRan) {
				enemy[pick].active = 1;
				pick++;
				numOfEnemies++;
				storyScore++;
				if (pick > 475) {
					stillEnemy[pick].active = 1;
					level++;
				}
				for (;;) {
					activater = 0;
					activaterRan = randomNum(10, 30);
					activaterRan2 = randomNum(0, 101);
					activaterRan3 = randomNum(0, 101);
					break;
				}
			}
			else if (activaterRan2 > 40) {
				activater = activaterRan;
				activaterRan2 = 0;
				activaterRan3 = 0;
			}
			else if (activaterRan3 > 30) {
				activater = activaterRan - 10;
				activaterRan2 = 0;
				activaterRan3 = 0;
			}
		}
		else if (level == 20) {
			activater++;
			if (activater > activaterRan) {
				enemy[pick].active = 1;
				pick++;
				numOfEnemies++;
				storyScore++;
				if (pick > 500) {
					stillEnemy[pick].active = 1;
					level++;
				}
				for (;;) {
					activater = 0;
					activaterRan = randomNum(10, 20);
					activaterRan2 = randomNum(0, 101);
					activaterRan3 = randomNum(0, 101);
					break;
				}
			}
			else if (activaterRan2 > 40) {
				activater = activaterRan;
				activaterRan2 = 0;
				activaterRan3 = 0;
			}
			else if (activaterRan3 > 20) {
				activater = activaterRan - 10;
				activaterRan2 = 0;
				activaterRan3 = 0;
			}
		}


		// The powerups
		if (powerSpeedTime > 0) powerSpeedTime--;
		if (powerSpeedTime <= 0) powerSpeed = 0;
		if (powerBulletTime > 0) powerBulletTime--;
		if (powerBulletTime <= 0) powerBullet = 0;
		if (powerShrinkTime > 0) powerShrinkTime--;
		if (powerShrinkTime <= 0) powerShrink = 0;
		if (powerInvinceTime > 0) powerInvinceTime--;
		if (powerInvinceTime <= 0) powerInvince = 0;
		powerUpTimer--;
		if (powerUpTimer <= 0) {
			// if the powerup is going to land on the player - move it
			if (((power[curPowerUp].x >= playerX) && (power[curPowerUp].x <= playerX+20) && (power[curPowerUp].y >= playerY) && (power[curPowerUp].y <= playerY+20))
				|| ((power[curPowerUp].x+20 >= playerX) && (power[curPowerUp].x+20 <= playerX+20) && (power[curPowerUp].y >= playerY) && (power[curPowerUp].y <= playerY+20))
				|| ((power[curPowerUp].x >= playerX) && (power[curPowerUp].x <= playerX+20) && (power[curPowerUp].y+20 >= playerY) && (power[curPowerUp].y+20 <= playerY+20))
				|| ((power[curPowerUp].x+20 >= playerX) && (power[curPowerUp].x+20 <= playerX+20) && (power[curPowerUp].y+20 >= playerY) && (power[curPowerUp].y+20 <= playerY+20))) {
				if (power[curPowerUp].x < 450) power[curPowerUp].x += 30;
				else power[curPowerUp].x -= 40;
			}
			power[curPowerUp].active = 1;
			if (curPowerUp <= MAX_POWERUPS) curPowerUp++;
			powerUpTimer = POWERUP_TIMER;
		}
		for (i=1; i<=MAX_POWERUPS; i++) {
			if (power[i].active) {
				if (((playerX >= power[i].x) && (playerX <= power[i].x+20) && (playerY >= power[i].y) && (playerY <= power[i].y+20))
					|| ((playerX+20 >= power[i].x) && (playerX+20 <= power[i].x+20) && (playerY >= power[i].y) && (playerY <= power[i].y+20))
					|| ((playerX >= power[i].x) && (playerX <= power[i].x+20) && (playerY+20 >= power[i].y) && (playerY+20 <= power[i].y+20))
					|| ((playerX+20 >= power[i].x) && (playerX+20 <= power[i].x+20) && (playerY+20 >= power[i].y) && (playerY+20 <= power[i].y+20))) {
						if (power[i].type==1) {
							powerSpeed = 1;
							powerSpeedTime = 500;
						}
						else if (power[i].type==2) {
							powerBullet = 1;
							powerBulletTime = 500;
						}
						else if (power[i].type==3) {
							powerShrink = 1;
							powerShrinkTime = 600;
						}
						else if (power[i].type==4) {
							powerInvince = 1;
							powerInvinceTime = 600;
						}
						power[i].active = 0;
				}
			}
		}

		// The green STILL enemies
		for (i=1; i<=MAX_ENEMIES; i++) {
			if (stillEnemy[i].active) {
				if (!(powerShrink)) {
					if (((playerX >= stillEnemy[i].x) && (playerX <= stillEnemy[i].x+20) && (playerY >= stillEnemy[i].y) && (playerY <= stillEnemy[i].y+20))
						|| ((playerX+20 >= stillEnemy[i].x) && (playerX+20 <= stillEnemy[i].x+20) && (playerY >= stillEnemy[i].y) && (playerY <= stillEnemy[i].y+20))
						|| ((playerX >= stillEnemy[i].x) && (playerX <= stillEnemy[i].x+20) && (playerY+20 >= stillEnemy[i].y) && (playerY+20 <= stillEnemy[i].y+20))
						|| ((playerX+20 >= stillEnemy[i].x) && (playerX+20 <= stillEnemy[i].x+20) && (playerY+20 >= stillEnemy[i].y) && (playerY+20 <= stillEnemy[i].y+20)))
						if (!(powerInvince)) 
							health -= 2;

				}
				else {
					if (((playerX >= stillEnemy[i].x) && (playerX <= stillEnemy[i].x+20) && (playerY >= stillEnemy[i].y) && (playerY <= stillEnemy[i].y+20))
						|| ((playerX+10 >= stillEnemy[i].x) && (playerX+10 <= stillEnemy[i].x+20) && (playerY >= stillEnemy[i].y) && (playerY <= stillEnemy[i].y+20))
						|| ((playerX >= stillEnemy[i].x) && (playerX <= stillEnemy[i].x+20) && (playerY+10 >= stillEnemy[i].y) && (playerY+10 <= stillEnemy[i].y+20))
						|| ((playerX+10 >= stillEnemy[i].x) && (playerX+10 <= stillEnemy[i].x+20) && (playerY+10 >= stillEnemy[i].y) && (playerY+10 <= stillEnemy[i].y+20)))
						if (!(powerInvince))
							health -= 2;
				}
			}
		}

		// Keep the bullets under control
		controlBullets();
	}
	else if (mode==DODGE_MODE) {
		// Control the level
		if (level == 1) {
			activater++;
			if (activater > activaterRan) {
				enemy[pick].active = 1;
				pick++;
				numOfEnemies++;
				if (pick > 25) {
					level++;
				}
				for (;;) {
					activater = 0;
					activaterRan = randomNum(100, 200);
					activaterRan2 = randomNum(0, 101);
					activaterRan3 = randomNum(0, 101);
					break;
				}
			}
			else if (activaterRan2 > 80) {	// 20% chance it will activate 2 instead of just 1
				activater = activaterRan;
				activaterRan2 = 0;
				activaterRan3 = 0;
			}
			else if (activaterRan3 > 80) {	// 20% chance it will increase the time for the next enemy to be activated
				activater = activaterRan - 30;
				activaterRan2 = 0;
				activaterRan3 = 0;
			}
		}
		else if (level == 2) {
			activater++;
			if (activater > activaterRan) {
				enemy[pick].active = 1;
				pick++;
				numOfEnemies++;
				if (pick > 50) {
					level++;
				}
				for (;;) {
					activater = 0;
					activaterRan = randomNum(60, 140);
					activaterRan2 = randomNum(0, 101);
					activaterRan3 = randomNum(0, 101);
					break;
				}
			}
			else if (activaterRan2 > 70) {	// 30% chance it will activate 2 instead of just 1
				activater = activaterRan;
				activaterRan2 = 0;
				activaterRan3 = 0;
			}
			else if (activaterRan3 > 80) {	// 20% chance it will increase the time for the next enemy to be activated
				activater = activaterRan - 25;
				activaterRan2 = 0;
				activaterRan3 = 0;
			}
		}
		else if (level == 3) {
			activater++;
			if (activater > activaterRan) {
				enemy[pick].active = 1;
				pick++;
				numOfEnemies++;
				if (pick > 75) {
					level++;
				}
				for (;;) {
					activater = 0;
					activaterRan = randomNum(50, 110);
					activaterRan2 = randomNum(0, 101);
					activaterRan3 = randomNum(0, 101);
					break;
				}
			}
			else if (activaterRan2 > 70) {
				activater = activaterRan;
				activaterRan2 = 0;
				activaterRan3 = 0;
			}
			else if (activaterRan3 > 60) {
				activater = activaterRan - 20;
				activaterRan2 = 0;
				activaterRan3 = 0;
			}
		}
		else if (level == 4) {
			activater++;
			if (activater > activaterRan) {
				enemy[pick].active = 1;
				pick++;
				numOfEnemies++;
				if (pick > 100) {
					level++;
				}
				for (;;) {
					activater = 0;
					activaterRan = randomNum(30, 80);
					activaterRan2 = randomNum(0, 101);
					activaterRan3 = randomNum(0, 101);
					break;
				}
			}
			else if (activaterRan2 > 70) {
				activater = activaterRan;
				activaterRan2 = 0;
				activaterRan3 = 0;
			}
			else if (activaterRan3 > 40) {
				activater = activaterRan - 25;
				activaterRan2 = 0;
				activaterRan3 = 0;
			}
		}
		else if (level == 5) {
			activater++;
			if (activater > activaterRan) {
				enemy[pick].active = 1;
				pick++;
				numOfEnemies++;
				if (pick > 125) {
					level++;
				}
				for (;;) {
					activater = 0;
					activaterRan = randomNum(20, 70);
					activaterRan2 = randomNum(0, 101);
					activaterRan3 = randomNum(0, 101);
					break;
				}
			}
			else if (activaterRan2 > 70) {
				activater = activaterRan;
				activaterRan2 = 0;
				activaterRan3 = 0;
			}
			else if (activaterRan3 > 30) {
				activater = activaterRan - 35;
				activaterRan2 = 0;
				activaterRan3 = 0;
			}
		}
		else if (level == 6) {
			activater++;
			if (activater > activaterRan) {
				enemy[pick].active = 1;
				pick++;
				numOfEnemies++;
				if (pick > 150) {
					level++;
				}
				for (;;) {
					activater = 0;
					activaterRan = randomNum(20, 70);
					activaterRan2 = randomNum(0, 101);
					activaterRan3 = randomNum(0, 101);
					break;
				}
			}
			else if (activaterRan2 > 70) {
				activater = activaterRan;
				activaterRan2 = 0;
				activaterRan3 = 0;
			}
			else if (activaterRan3 > 20) {
				activater = activaterRan - 35;
				activaterRan2 = 0;
				activaterRan3 = 0;
			}
		}
		else if (level == 7) {
			activater++;
			if (activater > activaterRan) {
				enemy[pick].active = 1;
				pick++;
				numOfEnemies++;
				if (pick > 175) {
					level++;
				}
				for (;;) {
					activater = 0;
					activaterRan = randomNum(20, 50);
					activaterRan2 = randomNum(0, 101);
					activaterRan3 = randomNum(0, 101);
					break;
				}
			}
			else if (activaterRan2 > 70) {
				activater = activaterRan;
				activaterRan2 = 0;
				activaterRan3 = 0;
			}
			else if (activaterRan3 > 20) {
				activater = activaterRan - 35;
				activaterRan2 = 0;
				activaterRan3 = 0;
			}
		}
		else if (level == 8) {
			activater++;
			if (activater > activaterRan) {
				enemy[pick].active = 1;
				pick++;
				numOfEnemies++;
				if (pick > 200) {
					level++;
				}
				for (;;) {
					activater = 0;
					activaterRan = randomNum(20, 50);
					activaterRan2 = randomNum(0, 101);
					activaterRan3 = randomNum(0, 101);
					break;
				}
			}
			else if (activaterRan2 > 50) {
				activater = activaterRan;
				activaterRan2 = 0;
				activaterRan3 = 0;
			}
			else if (activaterRan3 > 20) {
				activater = activaterRan - 30;
				activaterRan2 = 0;
				activaterRan3 = 0;
			}
		}
		else if (level == 9) {
			activater++;
			if (activater > activaterRan) {
				enemy[pick].active = 1;
				pick++;
				numOfEnemies++;
				if (pick > 225) {
					level++;
				}
				for (;;) {
					activater = 0;
					activaterRan = randomNum(20, 50);
					activaterRan2 = randomNum(0, 101);
					activaterRan3 = randomNum(0, 101);
					break;
				}
			}
			else if (activaterRan2 > 50) {
				activater = activaterRan;
				activaterRan2 = 0;
				activaterRan3 = 0;
			}
			else if (activaterRan3 > 20) {
				activater = activaterRan - 20;
				activaterRan2 = 0;
				activaterRan3 = 0;
			}
		}
		else if (level == 10) {
			activater++;
			if (activater > activaterRan) {
				enemy[pick].active = 1;
				pick++;
				numOfEnemies++;
				if (pick > 250) {
					level++;
				}
				for (;;) {
					activater = 0;
					activaterRan = randomNum(20, 50);
					activaterRan2 = randomNum(0, 101);
					activaterRan3 = randomNum(0, 101);
					break;
				}
			}
			else if (activaterRan2 > 50) {	// 30% chance it will activate 2 instead of just 1
				activater = activaterRan;
				activaterRan2 = 0;
				activaterRan3 = 0;
			}
			else if (activaterRan3 > 20) {	// 20% chance it will increase the time for the next enemy to be activated
				activater = activaterRan - 10;
				activaterRan2 = 0;
				activaterRan3 = 0;
			}
		}
		else if (level == 11) {
			activater++;
			if (activater > activaterRan) {
				enemy[pick].active = 1;
				pick++;
				numOfEnemies++;
				if (pick > 275) {
					level++;
				}
				for (;;) {
					activater = 0;
					activaterRan = randomNum(10, 40);
					activaterRan2 = randomNum(0, 101);
					activaterRan3 = randomNum(0, 101);
					break;
				}
			}
			else if (activaterRan2 > 50) {	// 30% chance it will activate 2 instead of just 1
				activater = activaterRan;
				activaterRan2 = 0;
				activaterRan3 = 0;
			}
			else if (activaterRan3 > 20) {	// 20% chance it will increase the time for the next enemy to be activated
				activater = activaterRan - 5;
				activaterRan2 = 0;
				activaterRan3 = 0;
			}
		}
		else if (level == 12) {
			activater++;
			if (activater > activaterRan) {
				enemy[pick].active = 1;
				pick++;
				numOfEnemies++;
				if (pick > 300) {
					level++;
				}
				for (;;) {
					activater = 0;
					activaterRan = randomNum(10, 30);
					activaterRan2 = randomNum(0, 101);
					activaterRan3 = randomNum(0, 101);
					break;
				}
			}
			else if (activaterRan2 > 30) {	// 30% chance it will activate 2 instead of just 1
				activater = activaterRan;
				activaterRan2 = 0;
				activaterRan3 = 0;
			}
			else if (activaterRan3 > 40) {	// 20% chance it will increase the time for the next enemy to be activated
				activater = activaterRan - 5;
				activaterRan2 = 0;
				activaterRan3 = 0;
			}
		}
		else if (level == 13) {
			activater++;
			if (activater > activaterRan) {
				enemy[pick].active = 1;
				pick++;
				numOfEnemies++;
				if (pick > 300) {
					level++;
				}
				for (;;) {
					activater = 0;
					activaterRan = randomNum(10, 30);
					activaterRan2 = randomNum(0, 101);
					activaterRan3 = randomNum(0, 101);
					break;
				}
			}
			else if (activaterRan2 > 50) {	// 30% chance it will activate 2 instead of just 1
				activater = activaterRan;
				activaterRan2 = 0;
				activaterRan3 = 0;
			}
			else if (activaterRan3 > 20) {	// 20% chance it will increase the time for the next enemy to be activated
				activater = activaterRan - 5;
				activaterRan2 = 0;
				activaterRan3 = 0;
			}
		}
		else if (level == 14) {
			activater++;
			if (activater > activaterRan) {
				enemy[pick].active = 1;
				pick++;
				numOfEnemies++;
				if (pick > 325) {
					level++;
				}
				for (;;) {
					activater = 0;
					activaterRan = randomNum(0, 20);
					activaterRan2 = randomNum(0, 101);
					activaterRan3 = randomNum(0, 101);
					break;
				}
			}
			else if (activaterRan2 > 30) {	// 30% chance it will activate 2 instead of just 1
				activater = activaterRan;
				activaterRan2 = 0;
				activaterRan3 = 0;
			}
			else if (activaterRan3 > 20) {	// 20% chance it will increase the time for the next enemy to be activated
				activater = activaterRan - 5;
				activaterRan2 = 0;
				activaterRan3 = 0;
			}
		}
		else if (level == 15) {
			activater++;
			if (activater > activaterRan) {
				enemy[pick].active = 1;
				pick++;
				numOfEnemies++;
				if (pick > 350) {
					level++;
				}
				for (;;) {
					activater = 0;
					activaterRan = randomNum(0, 20);
					activaterRan2 = randomNum(0, 101);
					activaterRan3 = randomNum(0, 101);
					break;
				}
			}
			else if (activaterRan2 > 30) {	// 30% chance it will activate 2 instead of just 1
				activater = activaterRan;
				activaterRan2 = 0;
				activaterRan3 = 0;
			}
			else if (activaterRan3 > 20) {	// 20% chance it will increase the time for the next enemy to be activated
				activater = activaterRan - 5;
				activaterRan2 = 0;
				activaterRan3 = 0;
			}
		}
		else if (level == 16) {
			activater++;
			if (activater > activaterRan) {
				enemy[pick].active = 1;
				pick++;
				numOfEnemies++;
				if (pick > 375) {
					level++;
				}
				for (;;) {
					activater = 0;
					activaterRan = randomNum(0, 20);
					activaterRan2 = randomNum(0, 101);
					activaterRan3 = randomNum(0, 101);
					break;
				}
			}
			else if (activaterRan2 > 30) {	// 30% chance it will activate 2 instead of just 1
				activater = activaterRan;
				activaterRan2 = 0;
				activaterRan3 = 0;
			}
			else if (activaterRan3 > 20) {	// 20% chance it will increase the time for the next enemy to be activated
				activater = activaterRan - 5;
				activaterRan2 = 0;
				activaterRan3 = 0;
			}
		}
		else if (level == 17) {
			activater++;
			if (activater > activaterRan) {
				enemy[pick].active = 1;
				pick++;
				numOfEnemies++;
				if (pick > 400) {
					level++;
				}
				for (;;) {
					activater = 0;
					activaterRan = randomNum(0, 20);
					activaterRan2 = randomNum(0, 101);
					activaterRan3 = randomNum(0, 101);
					break;
				}
			}
			else if (activaterRan2 > 30) {	// 30% chance it will activate 2 instead of just 1
				activater = activaterRan;
				activaterRan2 = 0;
				activaterRan3 = 0;
			}
			else if (activaterRan3 > 20) {	// 20% chance it will increase the time for the next enemy to be activated
				activater = activaterRan - 5;
				activaterRan2 = 0;
				activaterRan3 = 0;
			}
		}
		else if (level == 18) {
			activater++;
			if (activater > activaterRan) {
				enemy[pick].active = 1;
				pick++;
				numOfEnemies++;
				if (pick > 425) {
					level++;
				}
				for (;;) {
					activater = 0;
					activaterRan = randomNum(0, 20);
					activaterRan2 = randomNum(0, 101);
					activaterRan3 = randomNum(0, 101);
					break;
				}
			}
			else if (activaterRan2 > 30) {	// 30% chance it will activate 2 instead of just 1
				activater = activaterRan;
				activaterRan2 = 0;
				activaterRan3 = 0;
			}
			else if (activaterRan3 > 20) {	// 20% chance it will increase the time for the next enemy to be activated
				activater = activaterRan - 5;
				activaterRan2 = 0;
				activaterRan3 = 0;
			}
		}
		else if (level == 19) {
			activater++;
			if (activater > activaterRan) {
				enemy[pick].active = 1;
				pick++;
				numOfEnemies++;
				if (pick > 450) {
					level++;
				}
				for (;;) {
					activater = 0;
					activaterRan = randomNum(0, 20);
					activaterRan2 = randomNum(0, 101);
					activaterRan3 = randomNum(0, 101);
					break;
				}
			}
			else if (activaterRan2 > 30) {	// 30% chance it will activate 2 instead of just 1
				activater = activaterRan;
				activaterRan2 = 0;
				activaterRan3 = 0;
			}
			else if (activaterRan3 > 20) {	// 20% chance it will increase the time for the next enemy to be activated
				activater = activaterRan - 5;
				activaterRan2 = 0;
				activaterRan3 = 0;
			}
		}
		else if (level == 20) {
			activater++;
			if (activater > activaterRan) {
				enemy[pick].active = 1;
				pick++;
				numOfEnemies++;
				if (pick > 475) {
					level++;
				}
				for (;;) {
					activater = 0;
					activaterRan = randomNum(0, 20);
					activaterRan2 = randomNum(0, 101);
					activaterRan3 = randomNum(0, 101);
					break;
				}
			}
			else if (activaterRan2 > 30) {	// 30% chance it will activate 2 instead of just 1
				activater = activaterRan;
				activaterRan2 = 0;
				activaterRan3 = 0;
			}
			else if (activaterRan3 > 20) {	// 20% chance it will increase the time for the next enemy to be activated
				activater = activaterRan - 5;
				activaterRan2 = 0;
				activaterRan3 = 0;
			}
		}
	}

	// Control Health
	for (i=1; i<=MAX_ENEMIES; i++) {
		if (enemy[i].active) {
			if (!(powerShrink)) {
				if (((playerX >= enemy[i].x) && (playerX <= enemy[i].x+20) && (playerY >= enemy[i].y) && (playerY <= enemy[i].y+20))
					|| ((playerX+20 >= enemy[i].x) && (playerX+20 <= enemy[i].x+20) && (playerY >= enemy[i].y) && (playerY <= enemy[i].y+20))
					|| ((playerX >= enemy[i].x) && (playerX <= enemy[i].x+20) && (playerY+20 >= enemy[i].y) && (playerY+20 <= enemy[i].y+20))
					|| ((playerX+20 >= enemy[i].x) && (playerX+20 <= enemy[i].x+20) && (playerY+20 >= enemy[i].y) && (playerY+20 <= enemy[i].y+20)))
					if (!(powerInvince))
						health -= 2;
			}
			else {
				if (((playerX >= enemy[i].x) && (playerX <= enemy[i].x+20) && (playerY >= enemy[i].y) && (playerY <= enemy[i].y+20))
					|| ((playerX+10 >= enemy[i].x) && (playerX+10 <= enemy[i].x+20) && (playerY >= enemy[i].y) && (playerY <= enemy[i].y+20))
					|| ((playerX >= enemy[i].x) && (playerX <= enemy[i].x+20) && (playerY+10 >= enemy[i].y) && (playerY+10 <= enemy[i].y+20))
					|| ((playerX+10 >= enemy[i].x) && (playerX+10 <= enemy[i].x+20) && (playerY+10 >= enemy[i].y) && (playerY+10 <= enemy[i].y+20)))
					if (!(powerInvince))
						health -= 2;
			}
		}
	}
	if (health <= 0) {
		health = 0;
		dead = 1;
	}

	// Control squares sliding across
	for (i=1; i<=MAX_ENEMIES; i++) {
		if (enemy[i].active) {
			enemy[i].x = enemy[i].x + enemy[i].speed;
			if ((enemy[i].x > 480) || (enemy[i].x < -20) || (enemy[i].y > 272) || (enemy[i].y < -20)) enemy[i].active = 0; // Deactivate if out of screen
		}
	}
}

void shoot(int direction) {
	if (direction == BULLET_UP) {
		bullet[curBullet].x = playerX+4;
		bullet[curBullet].y = playerY;
		bullet[curBullet].dir = 1;
		bullet[curBullet].active = 1;
	}
	else if (direction == BULLET_RIGHT) {
		bullet[curBullet].x = playerX+10;
		bullet[curBullet].y = playerY+4;
		bullet[curBullet].dir = 2;
		bullet[curBullet].active = 1;
	}
	else if (direction == BULLET_DOWN) {
		bullet[curBullet].x = playerX+4;
		bullet[curBullet].y = playerY+10;
		bullet[curBullet].dir = 3;
		bullet[curBullet].active = 1;
	}
	else if (direction == BULLET_LEFT) {
		bullet[curBullet].x = playerX;
		bullet[curBullet].y = playerY+4;
		bullet[curBullet].dir = 4;
		bullet[curBullet].active = 1;
	}
	curBullet++;
}

void writeFile(const char *filename, const char *content) {
	SceUID file;
	file = sceIoOpen(filename, PSP_O_WRONLY|PSP_O_CREAT|PSP_O_TRUNC, 0777);
	sceIoWrite(file, content, strlen(content));
	sceIoClose(file);
}


// MAIN //

int main() {
	pspDebugScreenInit();

	// Initiate
	initGraphics();
	imgBackground = loadImage("./background.png");
	imgBullet = loadImage("./bullet.png");

	// Save score support (read from .sav file)
	storyHighScore = 0;
	dodgeHighScore = 0;

	SceCtrlData pad, oldpad;
	//sceDisplayWaitVblankStart();

menu:
	// Reset Variables
	sprintf(cont, "SCORE:%02d", storyHighScore);
	writeFile("./SCORE/story.sav", cont);
	sprintf(cont, "SCORE:%02d", dodgeHighScore);
	writeFile("./SCORE/dodge.sav", cont);

	initVars();
	level = initLevel(1, MAX_ENEMIES);

	// The main menu loop
	for (;;) {
		sceCtrlSetSamplingCycle(0);
		sceCtrlSetSamplingMode(PSP_CTRL_MODE_ANALOG);
		oldpad = pad;
		sceCtrlReadBufferPositive(&pad, 1);

		fillScreenRect(0xff554433, 0, 0, 480, 272);

		printTextScreen(10, 10, "Made By: PSPOwnage", 0);

		centerText(480/2, 60, "Story Mode", 10, 0);
		centerText(480/2, 75, "Dodge Mode", 10, 0);
		centerText(480/2, 90, "Help", 4, 0);
		centerText(480/2, 105, "Exit", 4, 0);

		char stat4[100];
		sprintf(stat4, "Story High Score: %02d", storyHighScore);
		centerText(480/2, 240, stat4, strlen(stat4), 0);
		char stat5[100];
		sprintf(stat5, "Dodge High Score: %02d", dodgeHighScore);
		centerText(480/2, 250, stat5, strlen(stat5), 0);

		if (menuOption==1) 
			centerText(480/2, 60, "Story Mode", 10, RGB(255, 0, 0));
		else if (menuOption==2) 
			centerText(480/2, 75, "Dodge Mode", 10, RGB(255, 0, 0));
		else if (menuOption==3) 
			centerText(480/2, 90, "Help", 4, RGB(255, 0, 0));
		else if (menuOption==4) 
			centerText(480/2, 105, "Exit", 4, RGB(255, 0, 0));

		if (pad.Buttons != oldpad.Buttons) {
			if ((pad.Buttons & PSP_CTRL_UP) && (!(oldpad.Buttons & PSP_CTRL_UP))) {
				menuOption--;
				if (menuOption <= 0) menuOption = 4;
			}
			else if ((pad.Buttons & PSP_CTRL_DOWN) && (!(oldpad.Buttons & PSP_CTRL_DOWN))) {
				menuOption++;
				if (menuOption >= 5) menuOption = 1;
			}
			if ((pad.Buttons & PSP_CTRL_CROSS) && (!(oldpad.Buttons & PSP_CTRL_CROSS))) {
				if (menuOption==1) {
					level = initLevel(STORY_MODE, MAX_ENEMIES);	// Initiate the level
					goto story;
				}
				else if (menuOption==2) {
					level = initLevel(DODGE_MODE, MAX_ENEMIES);	// Initiate the level
					goto dodge;
				}
				else if (menuOption==3) {
					goto help;
				}
				else if (menuOption==4) {
					goto exit;
				}
			}
		}

		#ifdef __DEBUG_
			break;
		#endif
		
		flipScreen();
		sceDisplayWaitVblankStart();
	}

story:
	// The STORY_MODE loop
	for (;;) {
		//clearScreen(0);

		sceCtrlSetSamplingCycle(0);
		sceCtrlSetSamplingMode(PSP_CTRL_MODE_ANALOG);
		oldpad = pad;
		sceCtrlReadBufferPositive(&pad, 1);

		levelControl(STORY_MODE);	// Control the current level

		// Gun
		timer++;
		if (!(powerSpeed)) {
			if (pad.Buttons & PSP_CTRL_TRIANGLE) {
				if (timer > BULLET_PAUSE) {
					shoot(BULLET_UP);
					timer = 0;
				}
			}
			else if (pad.Buttons & PSP_CTRL_CIRCLE) {
				if (timer > BULLET_PAUSE) {
					shoot(BULLET_RIGHT);
					timer = 0;
				}
			}
			else if (pad.Buttons & PSP_CTRL_CROSS) {
				if (timer > BULLET_PAUSE) {
					shoot(BULLET_DOWN);
					timer = 0;
				}
			}
			else if (pad.Buttons & PSP_CTRL_SQUARE) {
				if (timer > BULLET_PAUSE) {
					shoot(BULLET_LEFT);
					timer = 0;
				}
			}
		}
		else {
			if (pad.Buttons & PSP_CTRL_TRIANGLE) {
				if (timer > BULLET_PAUSE/2) {
					shoot(BULLET_UP);
					timer = 0;
				}
			}
			else if (pad.Buttons & PSP_CTRL_CIRCLE) {
				if (timer > BULLET_PAUSE/2) {
					shoot(BULLET_RIGHT);
					timer = 0;
				}
			}
			else if (pad.Buttons & PSP_CTRL_CROSS) {
				if (timer > BULLET_PAUSE/2) {
					shoot(BULLET_DOWN);
					timer = 0;
				}
			}
			else if (pad.Buttons & PSP_CTRL_SQUARE) {
				if (timer > BULLET_PAUSE/2) {
					shoot(BULLET_LEFT);
					timer = 0;
				}
			}
		}

		draw(STORY_MODE);	// Draw

		// Player Control
		playerMoveX = 0;
		playerMoveY = 0;

		if (!(powerSpeed)) {
			if (pad.Lx > 160 || pad.Lx < 96) {
				playerMoveX = (pad.Lx-128) / 36;
				playerX += playerMoveX;
			}
			else if (pad.Buttons & PSP_CTRL_RIGHT) playerX += 3;
			else if (pad.Buttons & PSP_CTRL_LEFT) playerY -= 3;
	
			if (pad.Ly > 160 || pad.Ly < 96) {
				playerMoveY = (pad.Ly-128) / 36;
				playerY += playerMoveY;
			}
			else if (pad.Buttons & PSP_CTRL_UP) playerY -= 3;
			else if (pad.Buttons & PSP_CTRL_DOWN) playerY += 3;
		}
		else {
			if (pad.Lx > 160 || pad.Lx < 96) {
				playerMoveX = (pad.Lx-128) / 28;
				playerX += playerMoveX;
			}
			else if (pad.Buttons & PSP_CTRL_RIGHT) playerX += 4.5;
			else if (pad.Buttons & PSP_CTRL_LEFT) playerY -= 4.5;
	
			if (pad.Ly > 160 || pad.Ly < 96) {
				playerMoveY = (pad.Ly-128) / 28;
				playerY += playerMoveY;
			}
			else if (pad.Buttons & PSP_CTRL_UP) playerY -= 4.5;
			else if (pad.Buttons & PSP_CTRL_DOWN) playerY += 4.5;
		}
		
		if (playerX < 0) playerX = 0;
		if (playerX > 460) playerX = 460;
		if (playerY < 0) playerY = 0;
		if (playerY > 252) playerY = 252;

		// Die
		if (dead) {
			if (storyScore > storyHighScore)
				storyHighScore = storyScore;
			goto menu;
		}

		// Pause
		if (pad.Buttons != oldpad.Buttons) {
			if ((pad.Buttons & PSP_CTRL_START) && (!(oldpad.Buttons & PSP_CTRL_START))) {
				for (;;) {
					sceCtrlSetSamplingCycle(0);
					sceCtrlSetSamplingMode(PSP_CTRL_MODE_ANALOG);
					oldpad = pad;
					sceCtrlReadBufferPositive(&pad, 1);

					blitAlphaImageToScreen(0, 0, 480, 272, imgBackground, 0, 0);
					fillScreenRect(RGB(255, 0, 0), playerX, playerY, 20, 20);		// The Player
					fillScreenRect(RGB(200, 0, 0), playerX+1, playerY+1, 18, 18);
					fillScreenRect(RGB(255, 0, 0), playerX+2, playerY+2, 16, 16);
					fillScreenRect(RGB(200, 0, 0), playerX+3, playerY+3, 14, 14);
					fillScreenRect(RGB(255, 0, 0), playerX+4, playerY+4, 12, 12);
					fillScreenRect(RGB(200, 0, 0), playerX+5, playerY+5, 10, 10);
					fillScreenRect(RGB(255, 0, 0), playerX+6, playerY+6, 8, 8);
					fillScreenRect(RGB(200, 0, 0), playerX+7, playerY+7, 6, 6);
					fillScreenRect(RGB(255, 0, 0), playerX+8, playerY+8, 4, 4);
					fillScreenRect(RGB(200, 0, 0), playerX+9, playerY+9, 2, 2);
					fillScreenRect(RGB(200, 0, 0), playerX+10, playerY+10, 0, 0);

					char stat[100];
					sprintf(stat, "Health: %02d", health);
					printTextScreen(1, 1, stat, RGB(255, 255, 255));
					char stat4[100];
					sprintf(stat4, "Score: %02d", storyScore);
					printTextScreen(1, 11, stat4, RGB(255, 255, 255));

					centerText(480/2, 50, "- Paused -", 10, RGB(255, 255, 255));

					centerText(480/2, 80, "Press Start To Unpause", 22, RGB(255, 255, 255));

					if (pad.Buttons != oldpad.Buttons) {
						if ((pad.Buttons & PSP_CTRL_START) && (!(oldpad.Buttons & PSP_CTRL_START))) break;
					}

					flipScreen();
					sceDisplayWaitVblankStart();
				}
			}
		}

		// Exit
		if (pad.Buttons & PSP_CTRL_HOME) goto menu;

		// Flip screen
		flipScreen();
		sceDisplayWaitVblankStart();
	}

dodge:
	// The DODGE_MODE loop
	for (;;) {
		//clearScreen(0);

		sceCtrlSetSamplingCycle(0);
		sceCtrlSetSamplingMode(PSP_CTRL_MODE_ANALOG);
		oldpad = pad;
		sceCtrlReadBufferPositive(&pad, 1);

		levelControl(DODGE_MODE);	// Control the current level

		draw(DODGE_MODE);	// Draw

		// Player Control
		playerMoveX = 0;
		playerMoveY = 0;

		if (pad.Lx > 160 || pad.Lx < 96) {
			playerMoveX = (pad.Lx-128) / 36;
			playerX += playerMoveX;
		}
		else if (pad.Buttons & PSP_CTRL_RIGHT) playerX += 3;
		else if (pad.Buttons & PSP_CTRL_LEFT) playerY -= 3;
	
		if (pad.Ly > 160 || pad.Ly < 96) {
			playerMoveY = (pad.Ly-128) / 36;
			playerY += playerMoveY;
		}
		else if (pad.Buttons & PSP_CTRL_UP) playerY -= 3;
		else if (pad.Buttons & PSP_CTRL_DOWN) playerY += 3;

		if (playerX < 0) playerX = 0;
		if (playerX > 460) playerX = 460;
		if (playerY < 0) playerY = 0;
		if (playerY > 252) playerY = 252;

		// Die
		if (dead) {
			if (numOfEnemies > dodgeHighScore)
				dodgeHighScore = numOfEnemies;
			goto menu;
		}

		// Pause
		if (pad.Buttons != oldpad.Buttons) {
			if ((pad.Buttons & PSP_CTRL_START) && (!(oldpad.Buttons & PSP_CTRL_START))) {
				for (;;) {
					sceCtrlSetSamplingCycle(0);
					sceCtrlSetSamplingMode(PSP_CTRL_MODE_ANALOG);
					oldpad = pad;
					sceCtrlReadBufferPositive(&pad, 1);

					blitAlphaImageToScreen(0, 0, 480, 272, imgBackground, 0, 0);
					fillScreenRect(RGB(255, 0, 0), playerX, playerY, 20, 20);		// The Player
					fillScreenRect(RGB(200, 0, 0), playerX+1, playerY+1, 18, 18);
					fillScreenRect(RGB(255, 0, 0), playerX+2, playerY+2, 16, 16);
					fillScreenRect(RGB(200, 0, 0), playerX+3, playerY+3, 14, 14);
					fillScreenRect(RGB(255, 0, 0), playerX+4, playerY+4, 12, 12);
					fillScreenRect(RGB(200, 0, 0), playerX+5, playerY+5, 10, 10);
					fillScreenRect(RGB(255, 0, 0), playerX+6, playerY+6, 8, 8);
					fillScreenRect(RGB(200, 0, 0), playerX+7, playerY+7, 6, 6);
					fillScreenRect(RGB(255, 0, 0), playerX+8, playerY+8, 4, 4);
					fillScreenRect(RGB(200, 0, 0), playerX+9, playerY+9, 2, 2);
					fillScreenRect(RGB(200, 0, 0), playerX+10, playerY+10, 0, 0);

					char stat1[100];
					sprintf(stat1, "Dodged: %02d", numOfEnemies);
					char stat2[100];
					sprintf(stat2, "Health: %02d", health);
					char stat3[100];
					sprintf(stat3, "Level: %02d", level);
					printTextScreen(1, 1, stat2, RGB(255, 255, 255));
					printTextScreen(1, 11, stat1, RGB(255, 255, 255));
					centerText(480/2, 0, stat3, strlen(stat3), RGB(255, 255, 255));

					centerText(480/2, 50, "- Paused -", 10, RGB(255, 255, 255));

					centerText(480/2, 80, "Press Start To Unpause", 22, RGB(255, 255, 255));

					if (pad.Buttons != oldpad.Buttons) {
						if ((pad.Buttons & PSP_CTRL_START) && (!(oldpad.Buttons & PSP_CTRL_START))) break;
					}

					flipScreen();
					sceDisplayWaitVblankStart();
				}
			}
		}

		// Exit
		if (pad.Buttons & PSP_CTRL_HOME) goto menu;

		// Flip screen
		flipScreen();
		sceDisplayWaitVblankStart();
	}

help:
	for (;;) {
		sceCtrlSetSamplingCycle(0);
		sceCtrlSetSamplingMode(PSP_CTRL_MODE_ANALOG);
		oldpad = pad;
		sceCtrlReadBufferPositive(&pad, 1);

		fillScreenRect(0xff554433, 0, 0, 480, 272);

		printTextScreen(10, 10, "Made By: PSPOwnage", 0);

		centerText(480/2, 20, "Help", 4, 0);
		printTextScreen(50, 50, "Story Mode:", 0);
		printTextScreen(70, 65, "- Analog/D-pad to move", 0);
		printTextScreen(70, 75, "- Shoot the blue squares", 0);
		printTextScreen(70, 85, "- Avoid the blue & green squares", 0);
		printTextScreen(70, 95, "- Collect powerups", 0);
		printTextScreen(70, 105, "- Score = 5 points per kill/1 point per dodge", 0);
		printTextScreen(70, 115, "- Get highest score as possible", 0);
		printTextScreen(50, 135, "Dodge Mode:", 0);
		printTextScreen(70, 150, "- Analog/D-pad to move", 0);
		printTextScreen(70, 160, "- Avoid the blue squares", 0);
		printTextScreen(70, 170, "- Every 25 dodged squares = next level", 0);
		printTextScreen(70, 180, "- Dodge as many squares as possible", 0);

		centerText(480/2, 250, "Press Home to Return", 20, 0);

		if (pad.Buttons & PSP_CTRL_HOME) goto menu;

		flipScreen();
		sceDisplayWaitVblankStart();
	}

exit:
	sceKernelExitGame();
	return 0;
}
